%------------------------------------------------------------------------------
% File     : CSR153^3 : TPTP v9.2.0. Released v5.3.0.
% Domain   : Commonsense Reasoning
% Problem  : Did someone like Bill in 2009?
% Version  : Especial.
% English  : During 2009 Mary liked Bill and Sue liked Bill. Is it the case
%            that someone liked Bill during 2009?

% Refs     : [BP10]  Benzmueller & Pease (2010), Progress in Automating Hig
%          : [Ben11] Benzmueller (2011), Email to Geoff Sutcliffe
% Source   : [Ben11]
% Names    :

% Status   : ContradictoryAxioms
% Rating   : 0.33 v9.1.0, 0.25 v9.0.0, 0.40 v8.2.0, 0.38 v8.1.0, 0.27 v7.5.0, 0.29 v7.4.0, 0.33 v7.2.0, 0.25 v7.1.0, 0.50 v7.0.0, 0.57 v6.4.0, 0.50 v6.3.0, 0.80 v6.2.0, 0.71 v5.5.0, 0.83 v5.4.0, 0.80 v5.3.0
% Syntax   : Number of formulae    : 5019 (1673 unt;1436 typ;   0 def)
%            Number of atoms       : 7512 ( 412 equ; 202 cnn)
%            Maximal formula atoms :   16 (   2 avg)
%            Number of connectives : 16699 ( 202   ~;  77   |;1322   &;14045   @)
%                                         ( 105 <=>; 948  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   26 (   5 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  : 1323 (1323   >;   0   *;   0   +;   0  <<)
%            Number of symbols     : 1439 (1435 usr; 993 con; 0-7 aty)
%            Number of variables   : 2573 (   2   ^;2077   !; 494   ?;2573   :)
% SPC      : TH0_CAX_EQU_NAR

% Comments :
%------------------------------------------------------------------------------
%----Include SUMO axioms
include('Axioms/CSR005^0.ax').
%------------------------------------------------------------------------------
%----The extracted Signature
thf(brother_THFTYPE_IiioI,type,
    brother_THFTYPE_IiioI: $i > $i > $o ).

thf(lBill_THFTYPE_i,type,
    lBill_THFTYPE_i: $i ).

thf(lBob_THFTYPE_i,type,
    lBob_THFTYPE_i: $i ).

thf(lMary_THFTYPE_i,type,
    lMary_THFTYPE_i: $i ).

thf(lSue_THFTYPE_i,type,
    lSue_THFTYPE_i: $i ).

thf(sister_THFTYPE_IiioI,type,
    sister_THFTYPE_IiioI: $i > $i > $o ).

%----The translated axioms
thf(ax,axiom,
    ( ( sister_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBill_THFTYPE_i )
    & ( sister_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBob_THFTYPE_i )
    & ( brother_THFTYPE_IiioI @ lBob_THFTYPE_i @ lBill_THFTYPE_i ) ) ).

thf(ax_001,axiom,
    ( ( (~) @ ( lMary_THFTYPE_i = lSue_THFTYPE_i ) )
    & ( (~) @ ( lMary_THFTYPE_i = lBill_THFTYPE_i ) )
    & ( (~) @ ( lBob_THFTYPE_i = lMary_THFTYPE_i ) ) ) ).

thf(ax_002,axiom,
    ( ( (~) @ ( lSue_THFTYPE_i = lBill_THFTYPE_i ) )
    & ( (~) @ ( lSue_THFTYPE_i = lBob_THFTYPE_i ) ) ) ).

thf(ax_003,axiom,
    ( ( (~) @ ( sister_THFTYPE_IiioI @ lMary_THFTYPE_i @ lSue_THFTYPE_i ) )
    & ( (~) @ ( sister_THFTYPE_IiioI @ lMary_THFTYPE_i @ lBill_THFTYPE_i ) )
    & ( (~) @ ( brother_THFTYPE_IiioI @ lBob_THFTYPE_i @ lMary_THFTYPE_i ) ) ) ).

thf(ax_004,axiom,
    (~) @ ( lBob_THFTYPE_i = lBill_THFTYPE_i ) ).

%----The translated conjectures
thf(con,conjecture,
    ? [R: $i > $i > $o] :
      ( ( R @ lBob_THFTYPE_i @ lBill_THFTYPE_i )
      & ( R @ lSue_THFTYPE_i @ lBob_THFTYPE_i )
      & ( (~)
        @ ! [X: $i,Y: $i] : ( R @ X @ Y ) ) ) ).

%------------------------------------------------------------------------------
